<?php

namespace App\Entities\Delivery;

use Illuminate\Database\Eloquent\Model;

class Phone extends Model
{
    protected $table = "dlv_Telefones";
    protected $primaryKey = ['idCliente', 'nrTelefone',];
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idCliente',
        'nrTelefone',
        'nrRamal',
        'idTipoTelefone',
        'flAtivo',
        'dtAlteracao'
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'idCliente','idCliente');
    }
}
