<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class KDSOrder extends Model
{
    use HasFactory;

    protected $table = 'kds_orders'; // Nome da tabela no banco de dados

    protected $primaryKey = 'id'; // Chave primária da tabela

    protected $fillable = [
        'idProduto',
        'stProduto',
        'idSetor',
        'stSetor',
        'stObservacao',
        'stStatus',
        'idComanda',
        'nrQuantidade',
        'stOperador',
        'flResposta',
        'dtData',
        'flAtivo',
        'idMicroterminal',
        'idMesa',
        'idAtendimento',
        'nrItem',
    ];

    protected $casts = [
        'flResposta' => 'boolean', // Cast para o tipo booleano
        'flAtivo' => 'boolean', // Cast para o tipo booleano
        'nrQuantidade' => 'decimal:3', // Cast para decimal com 3 casas decimais
        'dtData' => 'datetime', // Cast para datetime
    ];

    // O Laravel automaticamente trata timestamps created_at e updated_at
    // Se não quiser esses campos, desabilite o timestamp adicionando
    public $timestamps = false;
}
