<?php

namespace App\Entities\Nati;

use App\Entities\Nati\Customer;
use App\Traits\HasCompositePrimaryKey;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Extract extends Model implements Transformable
{
    use TransformableTrait;
    //    use HasCompositePrimaryKey;

    protected $table = 'cli_Extrato';
    protected $primaryKey = ['idExtrato', 'idAbertura'];
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idExtrato',
        'idAbertura',
        'idFatura',
        'idVenda',
        'idOperador',
        'idOperadorAutorizador',
        'idCliente',
        'dtData',
        'vrTotal',
        'vrDesconto',
        'vrAcrescimo',
        'vrSaldoAnterior',
        'vrQuitado',
        'flNotaFiscal',
        'flAtivo',
        'dtAlteracao',
        'cliente',
    ];

    protected $casts = [
        'flAtivo' => 'boolean',
        'flNotaFiscal' => 'boolean'
    ];

    public function cliente()
    {
        return $this->belongsTo(Customer::class, 'idCliente', 'idCliente');
    }

    public function itens()
    {
        return $this->hasMany(ItensExtract::class, 'idExtrato', 'idExtrato')
            ->where('idAbertura', $this->idAbertura);
    }
}
