<?php

namespace App\Entities\Nati;

use App\Traits\HasCompositePrimaryKey;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class ItensExtract extends Model implements Transformable
{
    use TransformableTrait;
    //    use HasCompositePrimaryKey;

    protected $table = 'cli_ItemExtrato';
    protected $primaryKey = ['idItem', 'idExtrato', 'idAbertura'];

    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idItem',
        'idExtrato',
        'idAbertura',
        'idProduto',
        'dtData',
        'nrQuantidade',
        'vrCusto',
        'vrUnitario',
        'vrDesconto',
        'flAtivo',
        'idComanda',
        'vrTotal',
        'vrTotalCusto',
        'flPago',
        'dtAlteracao',
    ];

    public function extrato(){
        return $this->belongsToMany(Extract::class, ['idExtrato', 'idAbertura'], ['idExtrato', 'idAbertura']);
    }

}
