<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class SaleDetails extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'cx_DetalhesVendas';

    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idVenda',
        'idAbertura',
        'idComanda',
        'idMesa',
        'dtData',
        'dtAlteracao'
    ];

    public function venda()
    {
        return $this->belongsTo(Sale::class, 'idVenda');
    }
}
