<?php

namespace App\Http\Controllers;

use App\Services\ReceiptFormService;
use Illuminate\Routing\Controller;


class FichaRecebimentoController extends Controller
{

    protected $service;

    /**
     * GerenciadorController constructor.
     * @param $service
     */
    public function __construct(ReceiptFormService $service)
    {
        $this->service = $service;
    }

    public function paymentDetail($id_open, $id_payment)
    {
        try {
            return response()->json($this->service->getPaymentDetail($id_open, $id_payment));

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function updateNSU(FichaRecebimentoUpdateRequest $request, $nsu)
    {
        try {
            return response()->json($this->service->updateNSU($request, $nsu));

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function updateAuthorize(FichaRecebimentoUpdateRequest $request, $authorize)
    {
        try {
            return response()->json($this->service->updateAuthorize($request, $authorize));

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function updatePayment(FichaRecebimentoUpdateRequest $request, $id_payment)
    {
        try {
            return response()->json($this->service->updatePayment($request, $id_payment));

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function conferredAll(FichaRecebimentoUpdateRequest $request, $id_open, $id_payment)
    {
        try {
            return response()->json($this->service->conferredAll($request->checked, $id_open, $id_payment));

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function getVoucher($id_payment)
    {
        try {
            return response()->json($this->service->getVoucher($id_payment));

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }
    public function getContaAssinada($id_payment)
    {
        try {
            return response()->json($this->service->getContaAssinada($id_payment));

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function depositContaAssinadaMoney($id_payment)
    {
        try {
            return response()->json($this->service->depositContaAssinadaMoney($id_payment));

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }
    public function depositContaAssinadaAll($id_payment)
    {
        try {
            return response()->json($this->service->depositContaAssinadaAll($id_payment));

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function conferred(FichaRecebimentoUpdateRequest $request, $checked)
    {
        try {
            return response()->json($this->service->conferred($request, $checked));

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }
}
