<?php

namespace App\Http\Controllers\Financeiro;

use App\Http\Controllers\Controller;
use App\Services\Nati\ConfigAdquirenteService;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\ConfigAdquirenteCreateRequest;
use App\Http\Requests\ConfigAdquirenteUpdateRequest;


class ConfigAdquirentesController extends Controller
{

    /**
     * @var ConfigAdquirenteService
     */
    protected $service;

    public function __construct(ConfigAdquirenteService $service) {

        $this->service = $service;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  ConfigAdquirenteCreateRequest $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(ConfigAdquirenteCreateRequest $request) {

        try {
            //
        } catch (ValidatorException $e) {
            //
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id) {

        try {
            $response = $this->service->getByConta($id);
            return response()->json(['data' => $response]);

        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => true, 'message' => 'id not found']);
        }
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
        //
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  ConfigAdquirenteUpdateRequest $request
     * @param  string            $id
     *
     * @return Response
     */
    public function update(ConfigAdquirenteUpdateRequest $request, $id) {

        try {
            //
        } catch (ValidatorException $e) {
            //
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        //
    }
}
