<?php

namespace App\Http\Controllers\Gestor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Entities\Nati\Extract;
use App\Services\Gestor\GestorIntegrationService;

class GestorIntegrationController extends Controller
{
    protected $service;
    public function __construct(GestorIntegrationService $service)
    {
        $this->service = $service;
    }
    public function sendInvoice(Request $request)
    {
        try {
            $invoice = $this->service->sendInvoice($request);
            return response()->json(['data' => $invoice], 201);
        } catch (Exception $e) {
            return response()->json(json_encode($e->getMessage()), 500);
        }
    }
}
