<?php

namespace App\Http\Controllers;

use App\Models\GestorConfig;
use Illuminate\Http\Request;
use App\Services\GestorConfigService;
use App\Http\Requests\GestorConfigRequest;

class GestorConfigController extends Controller
{
    protected $gestorConfigService;

    public function __construct(GestorConfigService $gestorConfigService)
    {
        $this->gestorConfigService = $gestorConfigService;
    }

    public function index()
    {
        try {
            $data = $this->gestorConfigService->getAll();
            return response()->json($data, 200);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }

    public function show($id)
    {
        try {
            $data = $this->gestorConfigService->getById($id);
            return response()->json($data, 200);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }

    public function store(GestorConfigRequest $request)
    {
        try {
            $res = $this->gestorConfigService->create($request->all());
            $config = [
                'id' => $res['id'],
                'url' => $res['url'],
                'token' => $res['token'],
                'usuario' => $res['usuario'],
            ];
            return response()->json([
                $config
            ], 201);

        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }    
    }

    public function update(GestorConfigRequest $request, $id)
    {
        try {
            $res = $this->gestorConfigService->update($id, $request);

            return response()->json([
                $res
            ], 201);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }

    public function destroy($id)
    {
        try {
            $this->gestorConfigService->delete($id);
            return response()->json(['message' => 'Deletado com sucesso'], 200);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
    
}
