<?php
namespace App\Http\Controllers;

use App\Events\NewOrdersToPreparation;
use App\Events\NewOrdersCancelled;
use App\Events\NewTablesTransferred;
use Illuminate\Http\Request;
use App\Services\KDSService;

class KDSController extends Controller
{
    private $service;
    public function __construct(KDSService $service)
    {

        $this->service = $service;
    }
    public function new(Request $request)
    {
        try {
            if(count($request->all()) > 0) {
                event(new NewOrdersToPreparation($request->all()));
                return response()->json([
                    'error' => false,
                    'message' => 'Orders dispatched successfully'
                ]);
            }
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }
    public function cancel(Request $request)
    {
        try {
            if(count($request->all()) > 0) {
                event(new NewOrdersCancelled($request->all()));
                $this->service->cancel($request->all());
                return response()->json([
                    'error' => false,
                    'message' => 'Orders cancelled dispatched successfully'
                ]);
            }
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }
    public function tableTransfer(Request $request)
    {
        try {
            if(count($request->all()) > 0) {
                event(new NewTablesTransferred($request->all()));
                return response()->json([
                    'error' => false,
                    'message' => 'tables transferred dispatched successfully'
                ]);
            }
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }
    public function tabDone(Request $request)
    {
        try {
            return $this->service->tabDone($request->all());
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }
    public function itemDone(Request $request)
    {
        try {
            return $this->service->itemDone($request->all());
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }
    public function getAll()
    {
        try {
            $this->handle();
            return $this->service->getAll();
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }

    public function handle()
    {
        $port = config('websockets.port', 6001); // Obtém a porta configurada (6001 por padrão)
        $serverRunning = $this->isWebSocketServerRunning($port);

        if (!$serverRunning) {
            \Log::info('WebSocket server is not running. Starting server...');
            $command = 'php artisan websockets:serve';
            \Illuminate\Support\Facades\Artisan::call('websockets:serve');
            \Log::info('Websockets server command executed.');
        } else {
            \Log::info('WebSocket server is already running.');
        }
    }
    private function isWebSocketServerRunning()
    {
        $port = config('websockets.port', 6001); // Obtém a porta configurada (6001 por padrão)
        $output = [];
        exec("netstat -an | find \"LISTEN\" | find \"$port\"", $output);

        return !empty($output);
    }

}
