<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\PayioService;

class PayioController extends Controller
{
    private $service;
    public function __construct(PayioService $service)
    {
        $this->service = $service;
    }

    public function getPDVs()
    {
        try {
            $pdvs = $this->service->getPDVs();
            return response()->json(['data' => $pdvs], 200);
        } catch (Exception $e) {
            return response()->json(json_encode($e->getMessage()), 500);
        }
    }

    public function getPDV($id)
    {
        try {
            $pdv = $this->service->getPDV($id);
            return response()->json(['data' => $pdv], 200);
        } catch (Exception $e) {
            return response()->json(json_encode($e->getMessage()), 500);
        }
    }

    public function store(Request $request)
    {
        try {
            $data = $request->all();
            $pdv = $this->service->create($data);
            return response()->json(['data' => $pdv], 201);
        } catch (Exception $e) {
            return response()->json(json_encode($e->getMessage()), 500);
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $data = $request->all();
            $pdv = $this->service->update($id, $data);
            return response()->json(['data' => $pdv], 200);
        } catch (Exception $e) {
            return response()->json(json_encode($e->getMessage()), 500);
        }
    }

    public function delete($id)
    {
        try {
            $this->service->delete($id);
            return response()->json(['message' => 'PDV deleted successfully'], 200);
        } catch (Exception $e) {
            return response()->json(json_encode($e->getMessage()), 500);
        }
    }
}
