<?php

namespace App\Observers;

use App\Entities\Nati\Customer;
use Illuminate\Support\Facades\Cache;

class CustomerObserver
{
    /**
     * Handle the customer "created" event.
     *
     * @param  Customer  $customer
     * @return void
     */
    public function created(Customer $customer)
    {
        Cache::tags(['ListaCustomer'])->flush();
    }

    /**
     * Handle the customer "updated" event.
     *
     * @param  Customer  $customer
     * @return void
     */
    public function updated(Customer $customer)
    {
        Cache::tags(['ListaCustomer'])->flush();
    }

    /**
     * Handle the customer "deleted" event.
     *
     * @param  Customer  $customer
     * @return void
     */
    public function deleted(Customer $customer)
    {
        Cache::tags(['ListaCustomer'])->flush();
    }

    /**
     * Handle the customer "restored" event.
     *
     * @param  Customer  $customer
     * @return void
     */
    public function restored(Customer $customer)
    {
        Cache::tags(['ListaCustomer'])->flush();
    }

    /**
     * Handle the customer "force deleted" event.
     *
     * @param  Customer  $customer
     * @return void
     */
    public function forceDeleted(Customer $customer)
    {
        Cache::tags(['ListaCustomer'])->flush();
    }
}
