<?php

namespace App\Providers;

use App\Events\PosOpened;
use App\Events\NewTabDone;
use App\Events\UserLoggedIn;
use App\Events\NewOrdersToPreparation;
use App\Listeners\PosOpenedListener;
use App\Listeners\UserLoggedInListeners;
use App\Listeners\NewOrdersToPreparationListener;
use App\Listeners\NewTabDoneListener;
use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Log;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
        'Laravel\Passport\Events\AccessTokenCreated' => [
            'App\Listeners\RevokeOldTokens',
        ],

        'Laravel\Passport\Events\RefreshTokenCreated' => [
            'App\Listeners\PruneOldTokens',
        ],
        PosOpened::class => [
            PosOpenedListener::class
        ],
        UserLoggedIn::class => [
            UserLoggedInListeners::class
        ],
        'App\Events\OrderCreated' => [
            'App\Listeners\OrderCreatedListener'
        ],
        'App\Events\DeliverySaleCreated' => [
            'App\Listeners\DeliverySaleCreatedListener'
        ],
        'App\Events\DeliveryOrderCfeCreated' => [
            'App\Listeners\DeliveryOrderCfeListener'
        ],
        NewOrdersToPreparation::class => [
            NewOrdersToPreparationListener::class,
        ],
        NewTabDone::class => [
            NewTabDoneListener::class,
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
