<?php

namespace App\Repositories;

use App\Entities\Financeiro\CentroCusto;
use App\Validators\Financeiro\CentroCustoValidator;
use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;

/**
 * Class CentroCustoRepositoryEloquent.
 *
 * @package namespace App\Repositories;
 */
class CentroCustoRepositoryEloquent extends BaseRepository implements CentroCustoRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return CentroCusto::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return CentroCustoValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }

}
