<?php

namespace App\Repositories\Nati;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\Nati\FichaFornecedorRepository;
use App\Entities\Nati\FichaFornecedor;
use App\Validators\Nati\FichaFornecedorValidator;

/**
 * Class FichaFornecedorRepositoryEloquent
 * @package namespace App\Repositories\Nati;
 */
class FichaFornecedorRepositoryEloquent extends BaseRepository implements FichaFornecedorRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return FichaFornecedor::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return FichaFornecedorValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
