<?php

namespace App\Repositories;

use App\Entities\Sangria;
use App\Validators\SangriaValidator;
use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;

/**
 * Class SangriaRepositoryEloquent
 * @package namespace App\Repositories\Nati;
 */
class SangriaRepositoryEloquent extends BaseRepository implements SangriaRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return Sangria::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {
        return SangriaValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
