<?php

namespace App\Repositories;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\vw_salesItensRepository;
use App\Entities\VwSalesItens;
use App\Validators\VwSalesItensValidator;

/**
 * Class VwSalesItensRepositoryEloquent.
 *
 * @package namespace App\Repositories;
 */
class VwSalesItensRepositoryEloquent extends BaseRepository implements VwSalesItensRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return VwSalesItens::class;
    }

    

    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
    
}
