<?php


namespace App\Services\Delivery;


use Carbon\Carbon;
use Modules\Delivery\Entities\CEP;

class CepService
{
    public function create($data)
    {
        return CEP::create([
            'idCEP' => $this->getNextId(),
            'stCEP' => $data['stCEP'],
            'stEndereco' => $data['stEndereco'],
            'stBairro' => $data['stBairro'],
            'stCidade' => $data['stCidade'],
            'stEstado' => $data['stEstado'],
            'dtAlteracao' => Carbon::now()
        ]);
    }

    public function getNextId()
    {
        return CEP::max('idCEP') + 1;
    }

    public function getByCep($data)
    {
        $cep = CEP::where('stCEP', $data)->first();
        if (!$cep) {
            return null;
        }
        return $cep->idCEP;
    }
}
