<?php

namespace App\Services;

use App\Entities\GestorConfig;
use App\Helpers\CryptoHelper;

class GestorConfigService
{
    public function getAll()
    {
        $config = GestorConfig::first();
        // $config->password = CryptoHelper::decryptPassword($config->password);
        return $config;
    }

    public function getConfigById($id)
    {
        return GestorConfig::findOrFail($id);
    }

    public function create($data)
    {
        if(is_object($data)) {
            $data = (array) $data;
        }
        return GestorConfig::create($data);
    }

    public function update($id, $data)
    {
        // $data['password'] = CryptoHelper::encryptPassword($data['password']);
        $gestorConfig = GestorConfig::findOrFail($id);
        $gestorConfig->update([
            'password' => $data['password'],
            'url' => $data['url'],
            'token' => $data['token'],
            'usuario' => $data['usuario']
        ]);

        return $gestorConfig;
    }

    public function delete($id)
    {
        $gestorConfig = GestorConfig::findOrFail($id);
        return $gestorConfig->delete();
    }
}
