<?php

namespace App\Services;
use App\Entities\KDSOrder;
use App\Events\NewTabDone;
use App\Events\NewItemDone;

class KDSService
{

    public function __construct()
    {

    }

    public function tabDone($req)
    {
        $orders = KDSOrder::where('idComanda', $req['tabId'])->get();
        foreach ($orders as $order) {
            $order->delete();
        }
        event(new NewTabDone($req['tabId']));
        return response()->json([
            'error' => false,
            'message' => 'Tab dispatched successfully'
        ]);
    }
    public function itemDone($req)
    {
        $order = KDSOrder::where('idComanda', $req['tabId'])->where('nrItem', $req['orderItem'])->first();
        $order->delete();

        event(new NewItemDone($req));
        return response()->json([
            'error' => false,
            'message' => 'Item dispatched successfully'
        ]);
    }
    public function getAll()
    {
        $orders = KDSOrder::where('flAtivo', true)->where('stStatus', '!=', 'Pronto')->get();
        return response()->json([
            'error' => false,
            'message' => 'Get orders successfully',
            'orders' => $orders
        ], 200);
    }

    public function cancel($orders)
    {
        foreach ($orders as $order) {
            KDSOrder::where('id', $order['id'])->delete();
        }
        return response()->json([
            'error' => false,
            'message' => 'Orders cancelled successfully'
        ]);
    }

}
