<?php

namespace App\Services;

use App\Entities\Manager;
use App\Entities\SaleTemp;
use App\Repositories\Nati\GerenciadorDetalhesRepository;
use App\Services\Nati\FechamentoService;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use App\Validators\ManagerValidator;
use App\Repositories\ManagerRepository;
use App\Repositories\ManagerDetailsRepository;
use Prettus\Validator\Contracts\ValidatorInterface;

class ManagerService extends Service
{
    protected $validator;
    protected $repository;
    protected $detalhesRepository;
    protected $fechamento;
    protected $stockService;

    public function __construct(
        ManagerValidator $validator,
        ManagerRepository $repository,
        ManagerDetailsRepository $detalhesRepository,
        FechamentoService $fechamento)
    {
        $this->validator = $validator;
        $this->repository = $repository;
        $this->detalhesRepository = $detalhesRepository;
        $this->fechamento = $fechamento;
    }

    public function fetch(array $request)
    {
        $flAberto = isset($request['flAberto']) ? $request['flAberto'] : true;
        $flConferencia = isset($request['flConferencia']) ? $request['flConferencia'] : false;
        $sort = isset($request['sort']) ? $request['sort'] :'dtAbertura';
        isset($request['orderDesc']) && $request['orderDesc'] == 'true' ? $order = 'desc' : $order = 'asc';
        isset($request['limit']) ? $limit = $request['limit'] : $limit = 10;
        isset($request['page']) ? $page = $request['page'] : $page = 1;
        $data = Manager::selectraw('
                cx_Gerenciador.idAbertura as idAbertura,
                cx_Gerenciador.dtAbertura as dtAbertura,
                cx_Gerenciador.idCaixa as idCaixa,
                op_Operadores.stApelido as stApelido
            ')
            ->join('op_Operadores', 'cx_Gerenciador.idOperador', '=', 'op_Operadores.idOperador')
            ->where(['cx_Gerenciador.flAberto' => $flAberto, 'cx_Gerenciador.flConferencia' => $flConferencia])
            ->orderBy($sort, $order)
            ->paginate($limit, $page);
        $data->append('total');

        return $data;
    }

    public function show($request, $id)
    {
        $flAberto = isset($request['flAberto']) ? $request['flAberto'] : true;
        $flConferencia = isset($request['flConferencia']) ? $request['flConferencia'] : true;
        $data = [];
        $data['hora'] = Carbon::now();
        $data['gerenciador'] = Manager::select(['idAbertura', 'idCaixa', 'dtAbertura', 'dtFechamento', 'stApelido', 'vrAbertura', 'nrClientes'])
            ->join('op_Operadores', 'cx_Gerenciador.idOperador', '=', 'op_Operadores.idOperador')
            ->where('flAberto', $flAberto)
            ->where('flConferencia', $flConferencia)
            ->where('idAbertura', '=', $id)
            ->first();

         $vendas = SaleTemp::where('idAbertura', $id)
            ->selectRaw('COALESCE(SUM(vrTotal),0) as vendas')
            ->selectRaw('COALESCE(COUNT(idVenda),0) as transacoes')
             ->where('flAtivo', true)
            ->groupBy('idAbertura')
            ->get()
            ->first();
         if(!$vendas){
             $data['vendas'] = ['vendas'=> 0, 'transacoes'=> 0];
         }else{
             $data['vendas'] = $vendas;
         }
        $fechamentoCego = DB::select("
            select * from cx_fechamento_cego where idGerenciador = $id
        ");
         $data['fechamentoCego'] = $fechamentoCego;

        $query = $this->getQueryRecebibemntos($id);
        $data['pagamentos'] = DB::select($query);

        $data['infos'] = [
            'desconto' => DB::select("SELECT COALESCE(COUNT(idVenda),0) AS 'qtd_desconto', COALESCE(SUM(vrDesconto),0) AS 'valor_desconto' FROM cx_Vendas_Temp WHERE flAtivo = 1 AND idAbertura = $id AND vrDesconto > 0")[0],
            'acrescimo' => DB::select("SELECT COALESCE(SUM(vrAcrescimo),0) as 'valor_acrescimo' FROM cx_Vendas_Temp WHERE flAtivo = 1 AND idAbertura = $id")[0],
            'sangria' => DB::select("SELECT COALESCE(COUNT(idSangria),0) AS 'qtd_sangria', COALESCE(SUM(vrSangria),0) AS 'valor_sangria' FROM cx_Sangrias WHERE flAtivo = 1 and vrSangria > 0 AND idAbertura = $id")[0],
            'suprimento' => DB::select("SELECT COALESCE(COUNT(idSangria),0) AS 'qtd_suprimento', COALESCE(SUM(vrSangria * -1),0) AS 'valor_suprimento' FROM cx_Sangrias WHERE flAtivo = 1 and vrSangria < 0 AND idAbertura = $id")[0],
            'repique' => DB::select("SELECT COALESCE(COUNT(idRepique),0) AS 'qtd_repique', COALESCE(SUM(vrRepique),0) AS 'valor_repique' FROM cx_Repique WHERE flAtivo = 1 AND idAbertura = $id")[0],
            'despesa' => DB::select("SELECT COALESCE(COUNT(idDespesa),0) AS 'qtd_despesa', COALESCE(SUM(vrDespesa),0) AS 'valor_despesa' FROM cx_Despesas WHERE flAtivo = 1 AND idAbertura = $id")[0],
            'venda_conta_assinada' => DB::select("SELECT COALESCE(COUNT(idExtrato),0) AS 'qtd_venda_conta_assinada', COALESCE(SUM(vrTotal - vrQuitado + vrDesconto + vrAcrescimo),0) AS 'valor_venda_conta_assinada' FROM cli_Extrato WHERE flAtivo = 1 AND idAbertura = $id")[0],
            'pagamento_conta_assinada' => DB::select("SELECT COALESCE(COUNT(idPagamento),0) AS 'qtd_pagamento_conta_assinada', COALESCE(SUM(vrPagamento),0) AS 'valor_pagamento_conta_assinada' FROM cli_Pagamento  WHERE flAtivo = 1 AND idAbertura = $id")[0],
            'cancelamento' => DB::select("SELECT COALESCE(COUNT(*),0) AS 'qtd_cancelamentos' FROM cx_Vendas_Temp WHERE flAtivo = '0' and idAbertura = $id")[0],
            'depositos' => DB::select("
                select idFormaPagamento, coalesce(sum(vrPagamento),0) as total from cli_Pagamento where idAbertura = $id and flAtivo = 1
			    group by idFormaPagamento, vrPagamento
			"),
            'vauchers_emitidos' => DB::select("SELECT COALESCE(COUNT(idVaucher),0) AS 'qtd_vauchers_emitidos', COALESCE(SUM(vrVaucher),0) AS 'vrVaucher' FROM cx_Vaucher WHERE flAtivo = 1 AND idAbertura = $id")[0],
            'itens_cancelados' => DB::select("SELECT COALESCE(COUNT(i.idItem),0) AS 'qtd_itens_cancelados', COALESCE(SUM(i.vrTotal),0) AS 'vrTotal' FROM cx_Itens_Temp as i JOIN cx_Vendas_Temp as v ON i.idVenda = v.idVenda AND i.idAbertura = v.idAbertura WHERE i.flAtivo = 0 AND i.idAbertura = $id and v.flAtivo = 1")[0],

        ];
        $query = $this->getQueryVauchersRecebidos($id);
        $data['infos']['vauchers_recebidos'] = DB::select($query);
        return $data;
    }

    private function getQueryRecebibemntos($idAbertura)
    {
        return "SELECT COALESCE(SUM(vrPagamento), 0) as vrPagamento, stFormaPagamento, idFormaPagamento, ParentId, [order], vrTaxa, idTipo
            FROM (
                SELECT SUM(p.vrFormaPagamento) as vrPagamento, f.stFormaPagamento, f.idFormaPagamento, f.ParentId, f.[order], f.vrTaxa, f.idTipo
                FROM cx_FormasPagamento f LEFT JOIN cx_FichaRecebimentos_Temp p
                ON f.idFormaPagamento = p.idFormaPagamento
                WHERE f.idTipo NOT IN ('6', '7', '9', '12', '13', '14', '16', '17', '20')
                AND f.flAtivo = '1' and p.idAbertura = $idAbertura and p.flAtivo=1 and f.ParentId = 0
                GROUP BY f.stFormaPagamento,f.idFormaPagamento, f.ParentId, f.[order], f.vrTaxa, f.idTipo
                union
                SELECT SUM(cp.vrPagamento) as vrPagamento, f.stFormaPagamento, f.idFormaPagamento, f.ParentId, f.[order], f.vrTaxa, f.idTipo
                FROM cx_FormasPagamento f
                left join cli_Pagamento cp on cp.idFormaPagamento = f.idFormaPagamento
                WHERE f.idTipo NOT IN ('1','6', '7', '9', '12', '14') and cp.idAbertura = $idAbertura and cp.flAtivo = 1
                GROUP BY f.stFormaPagamento,f.idFormaPagamento, f.ParentId, f.[order], f.vrTaxa, f.idTipo
                union
                select 0 as vrPagamento,stFormaPagamento,idFormaPagamento, Parentid, [order], vrTaxa, idTipo from cx_FormasPagamento
                where idTipo NOT IN ('6', '7', '9', '12', '13', '14', '16', '17', '20')  AND flAtivo = '1' and idFormaPagamento not in(
                select idFormaPagamento from cx_FichaRecebimentos_Temp where idAbertura = $idAbertura and flAtivo = 1) and ParentId = 0
                group by stFormaPagamento,idFormaPagamento, ParentId, [order], vrTaxa, idTipo

            ) as x GROUP BY stFormaPagamento, idFormaPagamento, ParentId, [order], vrTaxa, idTipo order by ParentId, [order]";
    }
    public function getQueryVauchersRecebidos($idAbertura)
    {
        return "SELECT COALESCE(SUM(vrPagamento), 0) as vrPagamento, stFormaPagamento, idFormaPagamento, ParentId, [order], vrTaxa, idTipo
                FROM (
                SELECT SUM(p.vrFormaPagamento) as vrPagamento, f.stFormaPagamento, f.idFormaPagamento, f.ParentId, f.[order], f.vrTaxa, f.idTipo
                FROM cx_FormasPagamento f LEFT JOIN cx_FichaRecebimentos_Temp p
                ON f.idFormaPagamento = p.idFormaPagamento
                WHERE f.idTipo = '20'
                AND f.flAtivo = '1' and p.idAbertura = $idAbertura and p.flAtivo=1 and f.ParentId = 0
                GROUP BY f.stFormaPagamento,f.idFormaPagamento, f.ParentId, f.[order], f.vrTaxa, f.idTipo
                union
                SELECT SUM(cp.vrPagamento) as vrPagamento, f.stFormaPagamento, f.idFormaPagamento, f.ParentId, f.[order], f.vrTaxa, f.idTipo
                FROM cx_FormasPagamento f
                left join cli_Pagamento cp on cp.idFormaPagamento = f.idFormaPagamento
                WHERE f.idTipo NOT IN ('1','6', '7', '9', '12', '14') and cp.idAbertura = $idAbertura and cp.flAtivo = 1
                GROUP BY f.stFormaPagamento,f.idFormaPagamento, f.ParentId, f.[order], f.vrTaxa, f.idTipo
                union
                select 0 as vrPagamento,stFormaPagamento,idFormaPagamento, Parentid, [order], vrTaxa, idTipo from cx_FormasPagamento
                where idTipo = '20'  AND flAtivo = '1' and idFormaPagamento not in(
                select idFormaPagamento from cx_FichaRecebimentos_Temp where idAbertura = $idAbertura and flAtivo = 1) and ParentId = 0
                group by stFormaPagamento,idFormaPagamento, ParentId, [order], vrTaxa, idTipo

            ) as x GROUP BY stFormaPagamento, idFormaPagamento, ParentId, [order], vrTaxa, idTipo order by ParentId, [order]
        ";
    }

    public function open($data)
    {
        $pos = [
            'idAbertura' => $this->nextId(),
            'dtAbertura' => Carbon::now(),
            'dtFechamento' => Carbon::now(),
            'vrAbertura' => 0,
            'vrFechamento' => 0,
            'flAberto' => true,
            'vrTrocoEncerramento' => 0,
            'flConferencia' => false,
            'nrClientes' => 0,
            'idOrigem' => 1,
            'idDestino' => 2,
            'dtAlteracao' => Carbon::now(),
            'idCaixa' => $data['idCaixa'],
            'idOperador' => $data['idOperador'],
        ];
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_CREATE);
        return $this->repository->create($pos);
    }

    public function close($id)
    {
        return $this->repository->update(['flAberto' => false], $id);
    }

    public function nextId()
    {
        return Manager::max('idAbertura') + 1;
    }

    public function getVendasByIdPayment($idAbertura, $idPagamento)
    {
        return DB::select("
            select v.idVenda,
            sum(v.vrTotal + v.vrAcrescimo - v.vrDesconto) as value,
            min(v.dtData) as dtData,
            p.idFormaPagamento
            from cx_Vendas_Temp as v
            inner join (
                select idVenda, idAbertura, idFormaPagamento
                from cx_FichaRecebimentos_Temp
                where flTroco = 0
                group by idVenda, idAbertura, idFormaPagamento
            ) as p on v.idVenda = p.idVenda and v.idabertura = p.idAbertura
            where v.idAbertura = $idAbertura and v.flAtivo= '1'
            group by v.idVenda, p.idFormaPagamento
        ");
    }

    public function getDetails($id, $action)
    {
        switch ($action) {
            case 'VENDAS':
                return DB::select("
                            select v.idVenda,
                            sum(v.vrTotal + v.vrAcrescimo - v.vrDesconto) as value,
                            min(v.dtData) as dtData,
                            p.idFormaPagamento,
                            c.stCliente
                            from cx_Vendas_Temp as v
                            inner join (
                                select idVenda, idAbertura, idFormaPagamento
                                from cx_FichaRecebimentos_Temp
                                where flTroco = 0
                                group by idVenda, idAbertura, idFormaPagamento
                            ) as p on v.idVenda = p.idVenda and v.idabertura = p.idAbertura
                            join dlv_clientes c on c.idCliente = v.idCliente
                            where v.idAbertura = $id and v.flAtivo= '1'
                            group by v.idVenda, p.idFormaPagamento, c.stCliente order by dtData"
                        );
            case 'DESCONTO':
                return DB::select("select vrDesconto as value, dtData, stApelido from [cx_Vendas_Temp] inner join [op_Operadores] on [op_Operadores].[idOperador] = [cx_Vendas_Temp].[idOperadorAutorizador] where [vrDesconto] > 0 and [idAbertura] = $id and [cx_Vendas_Temp].[flAtivo] = 1");
            case 'SANGRIA':
                return DB::select("select vrSangria as value, dtData, stApelido from [cx_Sangrias] inner join [op_Operadores] on [op_Operadores].[idOperador] = [cx_Sangrias].[idOperadorAutorizador] where [idAbertura] = $id and [cx_Sangrias].[flAtivo] = 1 and vrSangria > 0");
            case 'SUPRIMENTOS':
                return DB::select("select vrSangria * -1 as value, dtData, stApelido from [cx_Sangrias] inner join [op_Operadores] on [op_Operadores].[idOperador] = [cx_Sangrias].[idOperadorAutorizador] where [idAbertura] = $id and [cx_Sangrias].[flAtivo] = 1 and vrSangria < 0");
            case 'REPIQUE':
                return DB::select("select vrRepique as value, dtData, stApelido from [cx_Repique] inner join [op_Operadores] on [op_Operadores].[idOperador] = [cx_Repique].[idOperadorAutorizador] where [idAbertura] = $id and [cx_Repique].[flAtivo] = 1");
            case 'DESPESA':
                return DB::select("select vrDespesa as value, dtData, stDescricao as descricao, stFormaPagamento from [cx_Despesas] inner join [cx_FormasPagamento] on [cx_Despesas].[idFormaPagamento] = [cx_FormasPagamento].[idFormaPagamento] where [idAbertura] = $id and [cx_Despesas].[flAtivo] = 1");
            case 'VENDA CONTA ASSINADA':
                return DB::select("SELECT [stCliente],[dtData],[vrTotal] as value FROM [cli_Extrato] INNER JOIN [dlv_Clientes] ON [cli_Extrato].[idCliente] = [dlv_Clientes].[idCliente] WHERE [cli_Extrato].[flAtivo] = '1' AND [idAbertura] = $id");
            case 'DEPOSITOS':
                return DB::select("
                                            SELECT c.[stCliente], p.[dtData], p.[vrPagamento] as value, o.[stApelido], f.[stFormaPagamento]
                                            FROM cli_Pagamento as p
                                            INNER JOIN dlv_Clientes as c ON p.idCliente = c.idCliente
                                            INNER JOIN op_Operadores as o ON p.idOperadorAutorizador = o.idOperador
                                            INNER JOIN cx_FormasPagamento as f on f.idFormaPagamento = p.idFormaPagamento
                                            WHERE p.idAbertura = $id AND p.flAtivo = 1");
            case 'TAXA SERVICO':
                return DB::select("SELECT COALESCE(SUM(vrAcrescimo),0) as vrAcrescimo FROM CX_VENDAS_TEMP WHERE flAtivo = '1' AND idAbertura = '$id'");
            case 'VALE EMITIDO':
                $contraVale = DB::select("SELECT * FROM cx_FormasPagamento WHERE stFormaPagamento = 'CONTRA-VALE' OR stFormaPagamento = 'CONTRA VALE' OR idTipo = '7'");
                if($contraVale['idFormaPagamento']) {
                    return DB::select("
                        SELECT X.idVenda, X.idFicha, X.vrFormaPagamento, X.idAbertura, X.dtData, C.stCliente, (V.vrTotal - V.vrDesconto + V.vrAcrescimo) as vrTotal FROM
                        (SELECT * FROM cx_FichaRecebimentos_Temp UNION SELECT * FROM cx_FichaPagamentos)X INNER JOIN
                        (SELECT DISTINCT idVenda, idAbertura, vrTotal, flNotaFiscal, dtData, idCliente, vrDesconto, vrAcrescimo,
                        flAtivo, nrTempoAtendimento, idOperadorAutorizador, flDelivery, idAtendimentoDelivery FROM cx_Vendas_Temp
                        UNION
                        SELECT DISTINCT idVenda, idAbertura, vrTotal, flNotaFiscal, dtData, idCliente, vrDesconto, vrAcrescimo,
                        flAtivo, nrTempoAtendimento, idOperadorAutorizador, flDelivery, idAtendimentoDelivery FROM cx_Vendas) V
                        ON X.idVenda = V.idVenda AND X.idAbertura = V.idAbertura INNER JOIN dlv_Clientes C ON V.idCliente = C.idCliente WHERE X.flAtivo = '1' AND X.idAbertura = " . $id . "
                        AND X.idFormaPagamento = " . $contraVale['idFormaPagamento'] . " AND X.vrFormaPagamento > '0' ORDER BY 1
                    ");
                }
        }
    }

    public function getDetalhesVenda($idAbertura, $idVenda)
    {
        $itens = DB::select("select * from sales_item_list where idAbertura = $idAbertura and idVenda = $idVenda");
        $payments = DB::select("
            select ficha.idAbertura, ficha.idVenda, ficha.vrFormaPagamento, ficha.flTroco, fp.stFormaPagamento, ficha.idFicha
            from cx_FichaRecebimentos_Temp as ficha
            join cx_FormasPagamento as fp on fp.idFormaPagamento = ficha.idFormaPagamento
            where ficha.flAtivo = 1 and ficha.idAbertura = $idAbertura and ficha.idVenda = $idVenda
        ");
        $sale = DB::select("
                                    select vrAcrescimo, vrDesconto, vrTotal  from cx_vendas_temp where idvenda = $idVenda and idAbertura = $idAbertura
                                    union
                                    select vrAcrescimo, vrDesconto, vrTotal  from cx_vendas where idvenda = $idVenda and idAbertura = $idAbertura
        ");
        
        return [
            'itens' => $itens,
            'payments' => $payments,
            'tax' => number_format($sale[0]->vrAcrescimo, 2, '.', ''),
            'discount' => number_format($sale[0]->vrDesconto, 2, '.', ''),
            'total' => number_format($sale[0]->vrTotal, 2, '.', '')
        ];
    }

    public function getByPos($idCaixa, $idUsuario)
    {
        $gerenciador = $this->repository->findWhere([
            'idCaixa' => $idCaixa,
            'flAberto' => true
        ])->first();
        if ($gerenciador) {
            if ($gerenciador->needToClose()) {
                $this->close($gerenciador->idAbertura);
                return $this->open(['idCaixa' => $idCaixa, 'idOperador' => $idUsuario]);
            }
            return $gerenciador;
        } else {
            return $this->open(['idCaixa' => $idCaixa, 'idOperador' => $idUsuario]);
        }
    }

    public function getClosedById($id)
    {
        return $this->repository->find($id);
    }

    public function closedPdv($data, $idAbertura)
    {
        $hitoricoFechamento = DB::select("select * from cx_historicoFechamento where idabertura = '$idAbertura'");
        if($hitoricoFechamento) {
            throw new \Exception("Erro: Caixa duplicado");
        }
        return DB::transaction(function () use ($idAbertura, $data) {
            //Gerenciador Detalhes
            $this->fechamento->insertDetails($idAbertura, $data);
            //cx_historico
            $this->fechamento->insertHistoric($idAbertura, $data['historico']);
            //Update gerenciador
            $gerenciador = $this->getClosedById($idAbertura);
            $gerenciador->update([
                'flConferencia' => 1,
                'vrTrocoEncerramento' => $data['vrTrocoEncerramento'],
                'vrFechamento' => $data['vrFechamento'],
                'stOBS' => $data['observacao'],
                'dtAlteracao' => Carbon::now(),
            ]);
            //Set Stock
//            $this->stockService->setStockClosedPdv($idAbertura, $gerenciador);

            return $gerenciador;
        });
    }

    public function addSales($request, $id)
    {
        return DB::transaction(function () use ($request, $id) {
            $abertura = Manager::where('uuid', $id)->first();

            $venda = [
                'idVenda' => $request['idVenda'],
                'idAbertura' => $abertura->idAbertura,
                'vrTotal' => $request['vrTotal'],
                'flNotaFiscal' => $request['flNotaFiscal'],
                'dtData' => Carbon::parse($request['dtData']),
                'idCliente' => $request['idCliente'],
                'vrDesconto' => $request['vrDesconto'],
                'vrAcrescimo' => $request['vrAcrescimo'],
                'flAtivo' => $request['flAtivo'],
                'nrTempoAtendimento' => $request['nrTempoAtendimento'],
                'idOperadorAutorizador' => $request['idOperadorAutorizador'],
                'stFraseCupom' => $request['stFraseCupom'],
                'flDelivery' => $request['flDelivery'],
                'idAtendimentoDelivery' => $request['idAtendimentoDelivery'],
                'stContaAssinada' => $request['stContaAssinada'],
                'dtAlteracao' => Carbon::parse($request['dtAlteracao']),
                'nrCOO' => $request['nrCOO'],
                'stCPF' => $request['stCPF']
            ];

            $venda = $abertura->vendasTemp()->create($venda);

            foreach ($request['itens'] as $item) {
                $it = [
                    'idItem' => $item['idItem'],
                    'idVenda' => $venda->idVenda,
                    'idAbertura' => $venda->idAbertura,
                    'idProduto' => $item['idProduto'],
                    'dtData' => Carbon::parse($item['dtData']),
                    'nrQuantidade' => $item['nrQuantidade'],
                    'vrCusto' => $item['vrCusto'],
                    'vrUnitario' => $item['vrUnitario'],
                    'vrDesconto' => $item['vrDesconto'],
                    'flAtivo' => $item['flAtivo'],
                    'idComanda' => $item['idComanda'],
                    'idCodProduto' => $item['idCodProduto'],
                    'vrTotal' => $item['vrTotal'],
                    'vrTotalCusto' => $item['vrTotalCusto'],
                    'idOperadorAutorizador' => $item['idOperadorAutorizador'],
                    'stAtendente' => $item['stAtendente'],
                    'flEstoqueBaixado' => $item['flEstoqueBaixado'],
                    'flPromocao' => $item['flPromocao'],
                    'dtAlteracao' => Carbon::parse($item['dtAlteracao'])
                ];
                $venda->itens_temp()->create($it);
            }

            foreach ($request['payments'] as $pay) {
                $payment = [
                    'idFicha' => $pay['idFicha'],
                    'idVenda' => $venda->idVenda,
                    'idAbertura' => $abertura->idAbertura,
                    'idFormaPagamento' => $pay['idFormaPagamento'],
                    'vrFormaPagamento' => $pay['vrFormaPagamento'],
                    'dtdata' => Carbon::parse($pay['dtdata']),
                    'flTroco' => $pay['flTroco'],
                    'flAtivo' => $pay['flAtivo'],
                    'dtAlteracao' => Carbon::parse($pay['dtAlteracao']),
                    'flVaucher' => $pay['flVaucher']

                ];

                $venda->fichaRecebimento()->create($payment);
            }

            return $venda;
        });
    }

    public function addSangrias($request, $id)
    {
        return DB::transaction(function () use ($request, $id) {
            $abertura = Manager::where('uuid', $id)->first();

            $sangria = [
                'idSangria' => $request['idSangria'],
                'idAbertura' => $abertura->idAbertura,
                'idOperador' => $request['idOperador'],
                'dtData' => Carbon::parse($request['dtData']),
                'vrSangria' => $request['vrSangria'],
                'idFormaPagamento' => $request['idFormaPagamento'],
                'idOperadorAutorizador' => $request['idOperadorAutorizador'],
                'flAtivo' => $request['flAtivo'],
                'dtAlteracao' => Carbon::parse($request['dtAlteracao'])
            ];

            return $abertura->sangrias()->create($sangria);
        });
    }

    public function addDespesas($request, $id)
    {
        return DB::transaction(function () use ($request, $id) {
            $abertura = Manager::where('uuid', $id)->first();

            $despesa = [
                'idDespesa' => $request['idDespesa'],
                'idAbertura' => $abertura->idAbertura,
                'stDescricao' => $request['stDescricao'],
                'dtData' => Carbon::parse($request['dtData']),
                'vrDespesa' => $request['vrDespesa'],
                'idFormaPagamento' => $request['idFormaPagamento'],
                'flCompensando' => $request['flCompensando'],
                'flAtivo' => $request['flAtivo'],
                'dtAlteracao' => Carbon::parse($request['dtAlteracao'])

            ];

            return $abertura->despesas()->create($despesa);
        });
    }

    public function getPayments($idAbertura, $idFormaPagamento)
    {
        return DB::select("
        select * from cx_FichaRecebimentos_Temp f
        join cx_vendas_temp v
        on f.idAbertura = v.idAbertura and f.idVenda = v.idVenda
        join dlv_clientes c
        on v.idCliente = c.idCliente
        where f.idAbertura = $idAbertura and f.idFormaPagamento = $idFormaPagamento and f.flAtivo= '1'
        order by f.dtData
        ");
    }
    public function getCancelamentos($idAbertura)
    {
        return DB::select("
            SELECT I.dtData, P.stProduto, I.nrQuantidade, M.stMedida, M.flFracionado, I.vrTotal, O.stApelido, i.idVenda FROM cx_Itens_Temp I
            INNER JOIN prd_Produtos P ON I.idProduto = P.idProduto
            INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida
            RIGHT JOIN cx_vendas_temp v on I.idAbertura = v.idAbertura and I.idVenda = v.idVenda
            LEFT JOIN op_Operadores O ON I.idOperadorAutorizador = O.idOperador
            WHERE v.flAtivo = '0' AND I.idAbertura = '$idAbertura'
            ORDER BY I.dtData DESC
        ");
    }
    public function getEstornos($idAbertura)
    {
        return DB::select("
            SELECT I.dtData, P.stProduto, I.nrQuantidade, M.stMedida, M.flFracionado, I.vrTotal, O.stApelido, i.idVenda FROM cx_Itens_Temp I
            INNER JOIN prd_Produtos P ON I.idProduto = P.idProduto
            INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida
            LEFT JOIN cx_vendas_temp v on I.idAbertura = v.idAbertura and I.idVenda = v.idVenda
            LEFT JOIN op_Operadores O ON I.idOperadorAutorizador = O.idOperador
            WHERE I.flAtivo = '0' AND v.flAtivo = '1' AND I.idAbertura = '$idAbertura'
            ORDER BY I.dtData DESC
        ");
    }

    public function getNumbersPDV()
    {
       return DB::table('cx_gerenciador')
                    ->select('idCaixa')
                    ->groupBy('idCaixa')
                    ->orderBy('idCaixa')
                    ->get()
                    ->toArray();
    }
    public function reOpen($idAbertura)
    {
        $open = $this->ifNumberPDVInUse($idAbertura);
        if(isset($open[0]->idAbertura)) {
            throw new \Exception("Não foi possivel reabrir o caixa. Já existe um caixa com esse numero em uso no momento");
        }

        DB::statement("UPDATE cx_Gerenciador SET flAberto = '1' WHERE idAbertura = '$idAbertura'");
        $this->deleteFechamentoCego($idAbertura);
        return json_encode('Caixa reaberto');
    }

    private function ifNumberPDVInUse($idAbertura) {
        return DB::select("
            select * from cx_Gerenciador where idcaixa = (select idCaixa from cx_gerenciador where idabertura = '$idAbertura')
            and flAberto = 1
        ");
    }

    private function deleteFechamentoCego($idAbertura) {
        return DB::statement("
           delete from cx_fechamento_cego where idGerenciador = '$idAbertura'
        ");
    }
    public function getAvailableMethodsPayments()
    {
        return DB::select("select * from cx_FormasPagamento where idTipo not in (6,7,9,12,13,14,16,17,20) and flAtivo = 1");
    }
    public function updatePaymentMethod($detailsDto)
    {
        $idAbertura = intVal($detailsDto['idAbertura'], 10);
        $idVenda = intVal($detailsDto['idVenda'], 10);
        $idFicha = intVal($detailsDto['idFicha'], 10);
        $idFormaPagamento = intVal($detailsDto['idFormaPagamento'], 10);
        $ficha = DB::select("select * from cx_FichaRecebimentos_Temp where idAbertura = '{$idAbertura}' and idVenda = {$idVenda} and idFicha = '{$idFicha}'");
        if(!$ficha) {
            throw new \Exception("Ficha não encontrada");
        }
        DB::statement("
            update cx_FichaRecebimentos_temp set idFormaPagamento = {$idFormaPagamento} where idAbertura = {$idAbertura} and idVenda = {$idVenda} and idFicha = {$idFicha}
        ");
        return DB::select("select * from cx_FichaRecebimentos_Temp where idAbertura = '{$idAbertura}' and idVenda = {$idVenda} and idFicha = '{$idFicha}'");
    }

    public function delete($id)
    {
        $this->repository->delete($id);
        DB::statement("delete from cx_vendas_temp where idAbertura = '$id'");
        DB::statement("delete from cx_itens_temp where idAbertura = '$id'");
        DB::statement("DELETE FROM cx_FichaRecebimentos_temp WHERE idAbertura = '$id'");
        return json_encode('Caixa excluido com sucesso');
    }
    public function getCanceledItems($idAbertura)
    {
        return DB::select("
            SELECT I.dtData, P.stProduto, I.nrQuantidade, M.stMedida, M.flFracionado, I.vrTotal, O.stApelido, i.idVenda FROM cx_Itens_Temp I
            INNER JOIN prd_Produtos P ON I.idProduto = P.idProduto
            INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida
            LEFT JOIN op_Operadores O ON I.idOperadorAutorizador = O.idOperador
            WHERE I.flAtivo = '0' AND I.idAbertura = '$idAbertura'
            ORDER BY I.dtData DESC
        ");
    }
    public function searchSale($idVenda, $idAbertura)
    {
        return DB::select("
            SELECT V.idVenda, V.dtData, V.vrTotal, V.vrDesconto, V.vrAcrescimo, V.idCliente, C.stCliente, V.idOperadorAutorizador, O.stApelido
            FROM cx_Vendas_Temp V
            INNER JOIN dlv_Clientes C ON V.idCliente = C.idCliente
            WHERE V.idVenda = '$idVenda' AND V.idAbertura =
            '$idAbertura' AND V.flAtivo = '1'
        ");
    }
}
