<?php

namespace App\Services\Nati;

use Carbon\Carbon;
use App\Entities\Nati\ProdutoConfig;
use App\Repositories\Nati\ConfigRepository;
use App\Validators\Nati\ConfigValidator;

class ConfigService
{

    protected $repository;
    protected $validator;

    public function __construct(ConfigRepository $repository, ConfigValidator $validator)
    {

        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function config($request)
    {
        $data = [
            "flDtAlteracao" => $request["alteracao"] ? 1 : 0,
            "flCodigo" => $request["codigo"] ? 1 : 0,
            "flDesc" => $request["descricaoLonga"] ? 1 : 0,
            "flDescAbr" =>  $request["descricao"] ? 1 : 0,
            "flCategoria" => $request["categoria"] ? 1 : 0,
            "flSubCategoria" => $request["subcategoria"] ? 1 : 0,
            "flMedidaCompra" => 0,
            "flMedidaVenda" =>$request["medida"] ? 1 : 0,
            "flSetor" => $request["setor"] ? 1 : 0,
            "flVrCompra" => 0,
            "flVrVenda" => $request["preco"] ? 1 : 0,
            "flAliquota" => $request["aliquota"] ? 1 : 0,
            "dtAlteracao" => Carbon::now(),
            "flNCM" => $request["ncm"] ? 1 : 0,
            "flIdProduto" => $request["id"] ? 1 : 0,
        ];

        return $this->repository->update($data,1);
    }

    public function all()
    {
        return $this->repository->all();
    }
}
