<?php

namespace App\Services;

use App\Entities\PayioPDV;

class PayioService
{
    public function getPDVs()
    {
        $pdvs = PayioPDV::get();
        return $pdvs;
    }

    public function getPDV($id)
    {
        $pdv = PayioPDV::where('id', $id)->first();
        return $pdv;
    }

    public function create($data)
    {
        $pdv = PayioPDV::create([
            'storeId' => $data['storeId'] || null,
            'pdvId' => $data['pdvId'],
        ]);
        return $pdv;
    }

    public function update($id, $data)
    {
        $pdv = PayioPDV::where('id', $id)->first();
        if ($pdv) {
            $pdv->update([
                'storeId' => $data['storeId'] || null,
                'pdvId' => $data['pdvId'],
            ]);
            $pdv->save();
            return $pdv;
        }
        return null;
    }

    public function delete($id)
    {
        $pdv = PayioPDV::find($id);
        if ($pdv) {
            $pdv->delete();
            return true;
        }
        return false;
    }

}
