<?php

namespace App\Services;

use App\Entities\Nati\CustomerPayment;
use App\Repositories\Nati\CustomerPaymentRepository;
use App\Repositories\Nati\ExtractRepository;
use App\Repositories\ReceiptFormRepository;
use App\Repositories\VoucherRepository;
use App\Validators\ReceiptFormValidator;
use Illuminate\Support\Facades\DB;

class ReceiptFormService
{

    protected $repository;
    protected $validator;
    protected $voucherRepository;
    protected $extractRepository;
    protected $customerPayment;

    public function __construct
    (
        ReceiptFormRepository $repository,
        ReceiptFormValidator $validator,
        VoucherRepository $voucherRepository,
        ExtractRepository $extractRepository,
        CustomerPaymentRepository $customerPayment
    )
    {
        $this->repository = $repository;
        $this->validator = $validator;
        $this->voucherRepository = $voucherRepository;
        $this->extractRepository = $extractRepository;
        $this->customerPayment = $customerPayment;
    }

    //Todos os pagamentos ATIVOS realizados conforme o idFormaPagamento
    //Com deposito de conta assinada junto.
    public function getPaymentDetail($id_open, $id_payment)
    {
        $custumer_payments = DB::table('cli_Pagamento as CP')
            ->select(DB::raw("id = 0, idFormaPagamento as id_payment, id_venda = 0, CP.idAbertura as id_open"),
                DB::raw("CP.dtData as date, CP.vrPagamento as value_payment, autorizacao = '', nsu = '', CP.flConferido as conferred"))
            ->where('CP.flAtivo', true)
            ->where('CP.idAbertura', $id_open)
            ->where('CP.idFormaPagamento', $id_payment);

        $receiveds = DB::table('cx_FichaRecebimentos_Temp as FR')
            ->select(DB::raw("FR.idFicha as id, FR.idFormaPagamento as id_payment, FR.idVenda as id_venda"),
                DB::raw("FR.idAbertura as id_open, FR.dtData as date, FR.vrFormaPagamento as value_payment, FR.autorizacao, FR.nsu"),
                DB::raw("FR.flConferido as conferred"))
            ->where('FR.flAtivo', true)
            ->where('FR.idFormaPagamento', $id_payment)
            ->where('FR.idAbertura', $id_open)
            ->union($custumer_payments);

        return DB::table(DB::raw("({$receiveds->toSql()}) as x"))
            ->select(DB::raw('min(x.id) as id'),
                DB::raw("sum(x.value_payment) as value_payment, min(x.value_payment) as change, max(x.value_payment) as amount_paid"),
                DB::raw("x.id_payment, x.id_venda, x.id_open, x.date, x.autorizacao, x.nsu, x.conferred"))
            ->mergeBindings($receiveds)
            ->groupBy('x.id_payment', 'x.id_venda', 'x.id_open', 'x.date', 'x.autorizacao', 'x.nsu', 'x.conferred')
            ->orderBy('date', 'DESC')
            ->get();
    }

    public function updateNSU($request, $nsu)
    {
        return FichaRecebimento::where('id_venda', $request['id_venda'])
            ->where('id_open', $request['id_open'])
            ->update(['nsu' => $nsu]);
    }

    public function updateAuthorize($request, $athorize)
    {
        return FichaRecebimento::where('id_venda', $request['id_venda'])
            ->where('id_open', $request['id_open'])
            ->update(['autorizacao' => $athorize]);
    }

    public function updatePayment($request, $id_payment)
    {
        return FichaRecebimento::where('id_venda', $request['id_venda'])
            ->where('id_open', $request['id_open'])
            ->where('id_payment', $request['id_payment'])
            ->update(['idFormaPagamento' => $id_payment]);
    }

    public function getVoucher($id_open)
    {
        return $this->voucherRepository
            ->findWhere(['id_open' => $id_open, 'active' => true]);
    }

    public function getContaAssinada($id_open)
    {
        return $this->extractRepository
            ->findWhere(['id_open' => $id_open, 'active' => true]);
    }

    public function depositContaAssinadaMoney($id_open)
    {
        return $this->customerPayment->findWhere([
            'id_open' => $id_open,
            'id_type_payment' => 1,
            'active' => true
        ]);
    }

    public function depositContaAssinadaAll($id_open)
    {
        return $this->customerPayment->findWhere([
            'id_open' => $id_open,
            'active' => true
        ]);
    }

    public function conferredAll($checked, $id_open, $id_payment)
    {
        return DB::transaction(function () use ($checked, $id_open, $id_payment) {

            //Atualiza todos pagamentos efetuados por forma de pagamento
            FichaRecebimento::where('id_open', $id_open)
                ->where('id_payment', $id_payment)
                ->where('active', true)
                ->update(['flConferido' => $checked]);

            //Atualiza toos pagamentos (deposito de conta assinada) de clientes efetuados em cartão
            CustomerPayment::where('id_open', $id_open)
                ->where('id_payment', $id_payment)
                ->where('active', true)
                ->update(['flConferido' => $checked]);
        });
    }

    public function conferred($request, $checked)
    {
        if ($request['id_venda'] == 0 || $request['id_venda'] == null) {
            return CustomerPayment::where('id_open', $request['id_open'])
                ->where('id_payment', $request['id_payment'])
                ->where('date', $request['date'])
                ->where('active', true)
                ->update(['flConferido' => $checked]);
        } else {
            return FichaRecebimento::where('id_venda', $request['id_venda'])
                ->where('id_open', $request['id_open'])
                ->where('id_payment', $request['id_payment'])
                ->where('active', true)
                ->update(['flConferido' => $checked]);
        }
    }
}
