<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColunsDlvAtendimentos extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('dlv_atendimentos', function (Blueprint $table) {
            $table->string('idMobyo', 32)->nullable();
            $table->text('pixQrCodeMobyo')->nullable();
            $table->text('pixChaveMobyo')->nullable();
            $table->text('codigoDeRetiradaMobyo')->nullable();
            $table->text('linkDeRastreioMobyo')->nullable();
            $table->string('tipoDeEntrega')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('dlv_atendimentos', function (Blueprint $table) {
            $table->dropColumn([
                'idMobyo',
                'pixQrCodeMobyo',
                'pixChaveMobyo',
                'codigoDeRetiradaMobyo',
                'linkDeRastreioMobyo',
                'tipoDeEntrega',
            ]);
        });
    }
}
