<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePromoLevePague extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('prd_PromocaoLevePague')) {
            Schema::create('prd_PromocaoLevePague', function (Blueprint $table) {
                $table->id();
                $table->integer('idProduto');
                $table->integer('nrLeve');
                $table->integer('nrPague');
                $table->time('hrInicioPromocao')->nullable();
                $table->time('hrFimPromocao')->nullable();
                $table->date('dtInicioPromocao')->nullable();
                $table->date('dtFimPromocao')->nullable();
                $table->text('dias');
                $table->timestamps();
            });
        }
        if(!Schema::hasColumn('prd_produtos', 'flPromocaoLevePague')) {
            Schema::table('prd_produtos', function(Blueprint $table) {
                $table->boolean('flPromocaoLevePague')->default(0);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_PromocaoLevePague');
    }
}
