<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use phpDocumentor\Reflection\Types\Nullable;

class CreateOpGrupos extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('op_Grupos')) {
            Schema::create('op_Grupos', function (Blueprint $table) {
                $table->id('idGrupo')->unsigned()->autoIncrement();
                $table->string('stDescricao', 50);
                $table->string('cor', 7)->default('#000000')->nullable();
                $table->boolean('ativo')->default(true);
                $table->timestamps();
            });
        }

        if (Schema::hasTable('op_operadores')) {
            if (!Schema::hasColumn('op_operadores', 'idGrupo')) {
                Schema::table('op_operadores', function (Blueprint $table) {
                    $table->integer('idGrupo')->nullable()->unsigned();
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasTable('op_grupos')) {
            Schema::dropIfExists('op_grupos');
        }
    }
}
