<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMtItensAdicionaisTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('mt_ItensAdicionais')) {

            DB::statement('CREATE TABLE [dbo].[mt_ItensAdicionais](
                  [idComanda] [smallint] NOT NULL,
                  [nrItem] [smallint] NOT NULL,
                  [idItemAdicional] [int] NOT NULL,
                  [idMicroterminal] [nvarchar](15) NOT NULL,
                  [vrUnitario] [decimal](7, 2) NOT NULL,
                  [flCobrar] [nvarchar](10) NOT NULL,
                  [idOperadorCriacao] [int] NOT NULL,
                  [dtDataCriacao] [datetime] NOT NULL,
                  [dtAlteracao] [datetime] NOT NULL,
                  CONSTRAINT [PK_mt_ItensAdicionais] PRIMARY KEY CLUSTERED
                    (
                      [idComanda] ASC,
                      [nrItem] ASC,
                      [idItemAdicional] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mt_ItensAdicionais');

    }
}
