<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class InitWebSockets extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'init:websockets';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Start websockets';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $command = 'php artisan websockets:serve';
        
        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            // Para Windows
            pclose(popen('start /B ' . $command, 'r'));
        } else {
            // Para Unix-based
            exec($command . ' > /dev/null &');
        }

        $this->info('Websockets server started.');
        return 0;
    }
}
