<?php

namespace App\Entities\Financeiro;

use App\Entities\Nati\Customer;
use App\Traits\HasCompositePrimaryKey;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class ContasReceber extends Model implements Transformable
{
    use TransformableTrait;
//    //    use HasCompositePrimaryKey;

    protected $table = 'fin_ContasReceber';
    protected $primaryKey = 'idContasReceber';
    public $timestamps = false;
    public $incrementing = false;
    protected $fillable = [
        'idContasReceber',
        'idCliente',
        'idTipoConta',
        'dtLancamento',
        'dtVencimento',
        'dtRecebimento',
        'nrParcela',
        'nrTotalParcelas',
        'vrDocumento',
        'vrRecebido',
        'vrJuros',
        'flJuros',
        'flRecebido',
        'flAtivo',
        'stOperador',
        'stObservacao',
        'stDocumento',
        'stTipoBaixa',
        'stTipoJuros',
        'idFormaPagamento',
        'stObservacaoBaixa',
        'vrDescontoLancamento',
        'idContaBancaria',
        'idConta',
        'dtAlteracao',
        'idTipoPagamento',
        'stFormato',
        'externalCode'
    ];

    function clientes()
    {
        return $this->belongsTo(Customer::class,'idCliente');
    }

    public static function nextId($idCliente){
        return ContasReceberView::where('idCliente', $idCliente)
            ->max('idContasReceber') + 1;
    }

}
