<?php

namespace App\Entities\Financeiro;

use App\Entities\Nati\Customer;
use App\Traits\HasCompositePrimaryKey;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Lancamento extends Model implements Transformable
{
    use TransformableTrait;
//    //    use HasCompositePrimaryKey;

    protected $table = 'fin_ContasReceber';
    protected $primaryKey = ['idContasReceber','idCliente'];
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idContasReceber',
        'idCliente',
        'dtLancamento',
        'dtVencimento',
        'stDocumento',
        'nrParcela',
        'nrTotalParcelas',
        'flRecebido',
        'vrDocumento',
        'stOperador',
        'idTipoConta',
        'idConta',
        'dtRecebimento',
        'vrRecebido',
        'vrJuros',
        'flJuros',
        'flAtivo',
        'stObservacao',
        'stTipoBaixa',
        'stTipoJuros',
        'idFormaPagamento',
        'stObservacaoBaixa',
        'vrDescontoLancamento',
        'idContaBancaria',
        'dtAlteracao',
        'idTipopagamento',
        'stFormato',
    ];

    protected $hidden = [
        'cliente',
        'contas',
        'subgrupo',
    ];

    protected $maps = [
        'nome_cliente' => 'cliente.stCliente',
        'email_cliente' => 'cliente.stEmail',
        'conta' => 'conta.stConta',
        'idSub_grupo' => 'subgrupo.idTipoConta',
        'sub_grupo' => 'subgrupo.stTipoConta',
        'grupo' =>  'subgrupo.grupo.stCategoriaConta',
        'idGrupo' => 'subgrupo.grupo.idCategoriaConta',
    ];

//    protected $appends = [
//        'nome_cliente',
//        'email_cliente',
//        'conta',
//        'idSub_grupo',
//        'sub_grupo',
//        'idGrupo',
//        'grupo',
//    ];

    function cliente()
    {
        return $this->belongsTo(Customer::class,'idCliente');
    }

    function conta()
    {
        return $this->belongsTo(Conta::class,'idConta');
    }

    public function subgrupo()
    {
        return $this->belongsTo(SubGrupo::class, 'idTipoConta');
    }

}
