<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Categoria extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = "prd_categorias";
    protected $primaryKey = 'idCategoria';
    public $incrementing = false;
    public $timestamps = false;

    protected $hidden = [
        'stReservaCodigosInicio',
        'stReservaCodigosFim',
    ];

    protected $fillable = [
        'idCategoria',
        'stCategoria',
        'flAtivo',
        'dtAlteracao',
    ];

    protected $appends = [
        'produtos_count'
    ];

    protected $casts = [
        'flAtivo' => 'boolean',
    ];

    public function subCategorias()
    {
        return $this->hasMany(SubCategoria::class, "idCategoria", 'idCategoria');
    }

    public function produtos()
    {
        return $this->hasMany(Product::class, 'idCategoria')->where('flAtivo',true);
    }

    public function getProdutosCountAttribute()
    {
        return $this->produtos()->count();
    }
}
