<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
//use OwenIt\Auditing\Contracts\Auditable;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

/**
 * Class Prints.
 *
 * @package namespace App\Entities;
 */
class Prints extends Model implements Transformable
{
    use TransformableTrait;
//


    protected $table = 'mt_Prints';
    protected $primaryKey = 'idPrint';
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'id',
        'print',
        'locale',
        'canal',
        'model',
        'is_group_items',
        'updated_at',
        'colunas',
        'avancos'
    ];

    protected $casts = [
        'flAgruparItens' => 'boolean'
    ];

    protected $maps = [
        'id' => 'idPrint',
        'print' => 'stPrint',
        'locale' => 'stLocalPrint',
        'canal' => 'stCanal',
        'model' => 'stModelo',
        'is_group_items' => 'flAgruparItens',
        'updated_at' => 'dtAlteracao',
        'colunas' => 'nrColunas',
        'avancos' => 'nrAvancos'
    ];

    protected $hidden = [
        'idPrint',
        'stPrint',
        'stLocalPrint',
        'stCanal',
        'stModelo',
        'flAgruparItens',
        'dtAlteracao'
    ];

    protected $appends = [
        'id',
        'print',
        'locale',
        'canal',
        'model',
        'is_group_items',
        'updated_at',
    ];

    public function generateTags(): array
    {
        return [
            'config'
        ];
    }

    protected $auditExclude = [
        'dtAlteracao',
    ];
}
