<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

/**
 * Class RespostaObservacao.
 *
 * @package namespace App\Entities;
 */
class RespostaObservacao extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'prd_RespostaObservacao';
    protected $primaryKey = 'idObservacao';
    public $incrementing = true;
    public $timestamps = false;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'stObservacao',
        'dtAlteracao',
        'flAtivo'
    ];

    public function respostas()
    {
        return $this->hasMany(\App\Entities\Nati\Resposta::class, 'idRespostaObservacao', 'idObservacao');
    }

    public function perguntas()
    {
        return $this->belongsToMany(\App\Entities\Nati\Pergunta::class, 'prd_Respostas', 'idRespostaObservacao', 'idPergunta');
    }
}
