<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

/**
 * Class Entregador.
 *
 * @package namespace App\Entities;
 */
class SalesView extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'sales_list';
    protected $primaryKey = ['idVenda', 'idAbertura'];
    public $incrementing = false;
    public $timestamps = false;

    protected $casts = [
        'idAbertura' => 'int',
        'idVenda' => 'int',
        'idCaixa' => 'int',
        'vrTotal' => 'float',
        'flAtivo' => 'bool',
        'vrDesconto' => 'float',
        'vrAcrescimo' => 'float',
        'vrTotalBruto' => 'float',
    ];

}
