<?php

namespace App\Http\Controllers;

use App\Entities\Logs;
use Illuminate\Http\Request;
use App\Services\Nati\PerguntasService;

class PerguntasController extends Controller
{
    /**
     * @var PerguntasService
     */
    protected $service;

    /**
     * PerguntasController constructor.
     * @param PerguntasService $service
     */
    public function __construct(PerguntasService $service)
    {
        $this->service = $service;
    }
    public function getAll(Request $request)
    {
        try {
            return response()->json($this->service->getAll($request->all()));
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }

    public function create(Request $request)
    {
        try {
            $response = $this->service->store($request->all());
            $user = auth()->user();
            Logs::writeLog($user->stApelido, "PERGUNTAS", 'O USUARIO [' . $user->stApelido . '] CADASTROU A PERGUNTA [' . $request->description . ']');
            return response()->json($response, 201);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }
    public function filter(string $data)
    {
        try {
            return response()->json($this->service->filter($data));
        } catch (Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }
    public function show($id)
    {
        try {
            return $this->service->show($id);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }
    public function delete($id)
    {
        try {
            $this->service->delete($id);
            $user = auth()->user();
            Logs::writeLog($user->stApelido, "PERGUNTAS", 'O USUARIO [' . $user->stApelido . '] DELETOU A PERGUNTA [' . $id . ']');
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }
    public function update(Request $request)
    {
        try {
            $this->service->update($request->all());
            $user = auth()->user();
            Logs::writeLog($user->stApelido, "PERGUNTAS", 'O USUARIO [' . $user->stApelido . '] EDITOU A PERGUNTA [' . $request->description . ']');
        } catch (\Exception $e) {

        }
    }

}
