<?php


namespace App\Http\Controllers;


use App\Http\Controllers\Controller;
use App\Http\Resources\Sale as SaleResource;
use App\Services\Sales\SalesService;
use Illuminate\Http\Request;

class SalesController extends Controller
{
    protected $service;

    public function __construct(SalesService $service)
    {
        $this->service = $service;
    }

    public function get(Request $request)
    {
        try {
            $result = $this->service->get($request->query());

            return response()->json($result);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }

    public function getVenda($idAbertura, $idVenda)
    {
        try {
            $result = $this->service->getVenda($idAbertura, $idVenda);
            return new SaleResource($result);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function fromDelivery(Request $request, $idOrder)
    {
        try {
            $result = $this->service->fromDelivery($idOrder);
            return response()->json($result);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }

    public function getSalesItemsReport(Request $request)
    {
        try {
            $result = $this->service->getSalesItemsReport($request->query());

            return response()->json($result);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }

    public function getSalesReport(Request $request)
    {
        try {
            $result = $this->service->getSalesReport($request->query());

            return response()->json($result);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }
}
