<?php


namespace App\Http\Requests\Delivery;


use Illuminate\Foundation\Http\FormRequest;

class DispatchCreateRequest extends FormRequest
{
    /**
     * Transform the error messages into JSON
     *
     * @param array $errors
     * @return \Illuminate\Http\JsonResponse
     */
    public function response(array $errors)
    {
        return response()->json($errors, 422);
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'idMotoboy' => 'required',
            'stCupomDelivery' => 'required',
            'statusDr' => 'required'
        ];
    }
}
