<?php

namespace App\Repositories;

use App\Entities\Financeiro\CentroDeCusto;
use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Validators\CentroDeCustoValidator;

/**
 * Class CentroDeCustoRepositoryEloquent
 * @package namespace App\Repositories;
 */
class CentroDeCustoRepositoryEloquent extends BaseRepository implements CentroDeCustoRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return CentroDeCusto::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return CentroDeCustoValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
