<?php

namespace App\Repositories;

use App\Entities\Financeiro\ContaBancaria;
use App\Validators\Financeiro\ContaBancariaValidator;
use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;

/**
 * Class ContaBancariaRepositoryEloquent
 * @package namespace App\Repositories;
 */
class ContaBancariaRepositoryEloquent extends BaseRepository implements ContaBancariaRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return ContaBancaria::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return ContaBancariaValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
