<?php

namespace App\Repositories;

use App\Entities\Nati\TabelaNutricional;
use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\TabelaNutricionalRepository;
use App\Validators\TabelaNutricionalValidator;

/**
 * Class TabelaNutricionalRepositoryEloquent
 * @package namespace App\Repositories;
 */
class TabelaNutricionalRepositoryEloquent extends BaseRepository implements TabelaNutricionalRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return TabelaNutricional::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return TabelaNutricionalValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
