<?php

namespace App\Services;

use App\Entities\CEP;
use App\Repositories\CEPRepository;
use Carbon\Carbon;
use Exception;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;

class CEPService
{

    protected $repository;

    public function __construct(CEPRepository $repository)
    {
        $this->repository = $repository;
    }

    public function getById($id)
    {
        $response = $this->repository->find($id);

        return $response;
    }

    public function getByCEP($cep)
    {
        try {
            $data = $this->repository->findWhere(['stCEP' => $cep])->first();

            if ($data != null) {
                return $data;
            } else {
                $data = $this->apiGetCep($cep);
                return $data;
            }
        } catch (\Exception $e) {
            return $e;
        }

    }

    public function apiGetCep($cep)
    {
        $client = new Client();
        $url = 'https://viacep.com.br/ws/' . $cep . '/json/';
        try {
            $response = $client->request('GET', $url);
        } catch (GuzzleException $e) {
            return $e;
        }
        $data = $response->getBody();
        $data = json_decode($data, true);
        $erro = array_key_exists('erro', $data);

        if (!$erro) {
            $this->insertCep($data);
            $getCEP = $this->getByCEP($cep);
            return $getCEP;
        }
    }

    public function getByRua($rua)
    {

        if ($rua)
            return $this->repository->findWhere(['stEndereco' => $rua])->first();
//            return $this->repository->findByField('stCEP', $cep, ['idCEP'])[0]->idCEP;
        else return false;
    }

    public function search($string)
    {
        if ((int)$string == 0) {
            $result = CEP::where('stEndereco', 'LIKE', '%' . $string . '%')
                ->limit(10)->get();
        } else {
            $result = CEP::where('stEndereco', 'LIKE', '%' . (string)$string . '%')
                ->limit(10)->get();
        }
        return $result;
    }

    public function insertCep($data)
    {

        $cep = [
            "idCEP" => CEP::max('idCEP') + 1,
            "stCEP" => str_replace('-', "", $data['cep']),
            "stEndereco" => strtoupper($this->cleanString($data['logradouro'])),
            "stBairro" => strtoupper($this->cleanString($data['bairro'])),
            "stCidade" => strtoupper($this->cleanString($data['localidade'])),
            "stEstado" => $data['uf'],
            "dtAlteracao" => Carbon::now(),
        ];

        return $this->repository->create($cep);
    }

    public function cleanString($text)
    {
        $utf8 = array(
            '/[áàâãªä]/u' => 'a',
            '/[ÁÀÂÃÄ]/u' => 'A',
            '/[ÍÌÎÏ]/u' => 'I',
            '/[íìîï]/u' => 'i',
            '/[éèêë]/u' => 'e',
            '/[ÉÈÊË]/u' => 'E',
            '/[óòôõºö]/u' => 'o',
            '/[ÓÒÔÕÖ]/u' => 'O',
            '/[úùûü]/u' => 'u',
            '/[ÚÙÛÜ]/u' => 'U',
            '/ç/' => 'c',
            '/Ç/' => 'C',
            '/ñ/' => 'n',
            '/Ñ/' => 'N',
            '/–/' => '-', // UTF-8 hyphen to "normal" hyphen
            '/[’‘‹›‚]/u' => ' ', // Literally a single quote
            '/[“”«»„]/u' => ' ', // Double quote
            '/ /' => ' ', // nonbreaking space (equiv. to 0x160)
        );
        return preg_replace(array_keys($utf8), array_values($utf8), $text);
    }

    public function apiOnlineGetCep($cep)
    {
        $client = new Client();
        $url = 'https://viacep.com.br/ws/' . $cep . '/json/';
        try {
            $response = $client->request('GET', $url);
        } catch (GuzzleException $e) {
            return $e;
        }
        $data = $response->getBody();
        $data = json_decode($data, true);
        $erro = array_key_exists('erro', $data);

        if (!$erro) {
            // $this->insertCep($data);
            // $getCEP = $this->getByCEP($cep);
            // return $getCEP;
            return $data;
        }
    }

}
