<?php
/**
 * Created by PhpStorm.
 * User: Kaio F.
 * Date: 20/06/2017
 * Time: 15:30
 */
namespace App\Services;

use App\Repositories\ClienteRepository;
use App\Validators\ClienteValidator;
use App\Entities\Cliente;
use Carbon\Carbon;
use Prettus\Validator\Contracts\ValidatorInterface;
use Yajra\Datatables\Datatables;

class ClienteService {

    protected $repository;
    protected $validator;
    protected $cep;
    protected $operador;

    public function __construct(ClienteRepository $repository, ClienteValidator $validator, CEPService $cep, OperadorService $operador) {
        $this->repository = $repository;
        $this->validator = $validator;
        $this->cep = $cep;
        $this->operador = $operador;
    }

    public function get() {
        return Cliente::where('flAtivo', '=', true)->where('idCliente', '>', 1);
    }

    public function getById($id) {
        $clientes = $this->repository->find($id);
        return [
            'clientes' => $clientes,
            'CEP' => $this->cep->getById($clientes->idCEP)
        ];
    }

    public function getCEP($data)
    {
        return !isset($data['endereco']['idCEP']) || strlen($data['endereco']['idCEP']) == 0 || $data['endereco']['idCEP'] == "0"
            ? 0
            : $this->cep->getByCEP($data['endereco']['stCEP'])->idCEP;
    }

    public function insert($data) {

        $data['idCliente'] = Cliente::max('idCliente') + 1;
        $data['stOperador'] = $this->operador->getNameById($data['stOperador']);
        $data['idCEP'] = $this->getCEP($data);
        $data['dtCadastro'] = Carbon::now();
        $data['dtAlteracao'] = Carbon::now();
        $data['dtUltimaAlteracao'] = $data['dtCadastro'];
        $data['stOperadorUltimaAlteracao'] = $data['stOperador'];
        $data['flAtivo'] = true;
        $data['idMotivoBloqueio'] = 0;
        $data['nrNumero'] = 0;

        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_CREATE);
        return $this->repository->create($data);
    }

    public function update($data, $id) {

        // Verifica se há um CEP valido e atualiza se necessário
        // Caso contrário seta pra zero.
        $data['idCEP'] = $this->getCEP($data);
        $data['dtUltimaAlteracao'] = Carbon::now();
        $data['stOperadorUltimaAlteracao'] = $this->operador->getNameById($data['stOperador']);
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);
        return $this->repository->update($data, $id);
    }

    public function delete($id) {

        return $this->repository->update(['flAtivo' => false], $id);
    }

}