<?php
/**
 * Created by PhpStorm.
 * User: ARCNET DEV
 * Date: 13/11/2017
 * Time: 13:04
 */

namespace App\Services;


use App\Repositories\Nati\DespesaRepository;
use App\Validators\Nati\DespesaValidator;

class ExpenseService
{
    protected $repository;
    protected $validator;

    public function __construct(DespesaRepository $repository, DespesaValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function get()
    {
        return $this->repository->with('formaPagamento')->all();
    }

    public function getByIdAbertura($id)
    {
        return $this->repository->with('formaPagamento')->findWhere(['idAbertura' => $id]);
    }

    public function getTotalDespesa($id)
    {
        return $this->getByIdAbertura($id)->reduce(function ($total, $item) {
            return $total + floatval($item->vrDespesa);
        }) | 0;
    }
}
