<?php

namespace App\Services\Gestor;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;

class GestorAuthService
{
    protected $client;
    protected $url;
    protected $username;
    protected $password;

    public function __construct($url, $username, $password)
    {
        $this->client = new Client();
        $this->url = $url;
        if (substr($this->url, -1) != '/') {
            $this->url .= '/';
        }
        $this->username = $username;
        $this->password = $password;
    }

    /**
     * Obtém um token JWT da API de autenticação
     */
    public function getToken()
    {
        // Verifica se o token já está em cache
        if (Cache::has('jwt_token')) {
            return Cache::get('jwt_token');
        }

        try {
            $response = $this->client->post($this->url . 'login-jwt', [
                'json' => [
                    'login' => $this->username,
                    'senha' => $this->password,
                ],
                'headers' => [
                    'Accept' => 'application/json',
                ],
            ]);

            $data = json_decode($response->getBody()->getContents(), true);

            if (isset($data['token'])) {
                // Armazena o token no cache por 30 minutos
                Cache::put('jwt_token', $data['token'], now()->addMinutes(180));
                return $data['token'];
            }

            Log::error('Token JWT não encontrado na resposta da API: [EER2A]: '. $response->getBody()->getContents());

        } catch (RequestException $e) {
            Log::error('Erro ao obter token JWT: [EER1A]: ' . $e->getMessage());
        }
    }
}
