<?php


namespace App\Services\Reports;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class CommissionReportService
{
    public function getCommissions ($request)
    {
        $commissionBasedOnSales = $request['commissionBasedOnSales'];
        $filterSalesWithService = $request['filterSalesWithService'];
        $filterItemsWithService = $request['filterItemsWithService'];
        $startDate = Carbon::createFromFormat('d/m/Y', $request['start'])->toDateString() . ' 00:00:00';
        $endDate = Carbon::createFromFormat('d/m/Y', $request['end'])->toDateString() . ' 23:59:59';

        $salesAmount = DB::select(
            "SELECT SUM(I.vrTotal) AS vrTotal
            FROM
            (SELECT idVenda, idAbertura, vrTotal, dtData, vrAcrescimo, flAtivo FROM cx_Vendas UNION SELECT idVenda, idAbertura, vrTotal, dtData, vrAcrescimo, flAtivo FROM cx_Vendas_Temp) V
            INNER JOIN
            (SELECT * FROM cx_Itens UNION SELECT * FROM cx_Itens_Temp) I
                                            ON V.idAbertura = I.idAbertura AND V.idVenda = I.idVenda
            WHERE V.flAtivo = 'true' AND I.flAtivo = 'true' AND V.dtData BETWEEN '$startDate' AND '$endDate' ".($commissionBasedOnSales == 'true' ? "AND V.vrAcrescimo > 0" : "")
        );


        $query = "
        DECLARE @vrTaxaServico AS DECIMAL(9,2);
        SET @vrTaxaServico =(SELECT vrTaxaServico FROM [Master]);
        SELECT I.stAtendente, SUM(I.vrTotal) AS vrTotal, (SUM(I.vrTotal) * (@vrTaxaServico * 100) / 100) AS vrComissao, @vrTaxaServico AS vrTaxaServico
        FROM
        (SELECT idVenda, idAbertura, vrTotal, dtData, vrAcrescimo, flAtivo FROM cx_Vendas UNION SELECT idVenda, idAbertura, vrTotal, dtData, vrAcrescimo, flAtivo FROM cx_Vendas_Temp) V
        INNER JOIN
        (SELECT * FROM cx_Itens UNION SELECT * FROM cx_Itens_Temp) I
        ON V.idAbertura = I.idAbertura AND V.idVenda = I.idVenda
        WHERE V.flAtivo = 'true' AND I.flAtivo = 'true' AND V.dtData BETWEEN '$startDate' AND '$endDate'"; 
        if($filterSalesWithService || $filterItemsWithService) {
            $query .= " AND V.vrAcrescimo > 0";
        }
        $query .= "GROUP BY I.stAtendente";
        $result = DB::select($query);


        if($filterItemsWithService == 'true') {
            $query = "
			SELECT SUM(v.vrAcrescimo) AS vrComissao
            FROM
            (SELECT idVenda, idAbertura, vrTotal, dtData, vrAcrescimo, flAtivo FROM cx_Vendas UNION SELECT idVenda, idAbertura, vrTotal, dtData, vrAcrescimo, flAtivo FROM cx_Vendas_Temp) V
            WHERE V.flAtivo = 'true' AND V.dtData BETWEEN '2024-11-26 00:00:00' AND '2024-11-26 23:59:59' and v.vrAcrescimo > 0 
            ";
            $serviceByItem = DB::select($query);
        }

        if(!empty($result)) {
            $commissionTotal = 0;
            foreach ($result as $item) {
                $commissionTotal += $item->vrComissao;
            }

            $qtdOfWaiters = count($result);

            //Se o tipo de comissão for divida de acordo com valor total vendido por cada garçon
            if ($commissionBasedOnSales == 'true') {
                foreach ($result as $item) {
                    $percentCommissionPerWaiter = 0;
                    $percentCommissionPerWaiter = $item->vrComissao * 100 / $commissionTotal;
                    $item->percentCommission = number_format(($percentCommissionPerWaiter), 2, ',', '.');
                }
            }else {
            //Se o tipo de comissao for dividida igualmente para todos os garçons
                if($filterItemsWithService) {
                    $commissionTotal = $serviceByItem[0]->vrComissao;
                }
                $commissionPerWaiter = $commissionTotal / $qtdOfWaiters;
                $percentCommissionPerWaiter = 100 / $qtdOfWaiters;
                foreach ($result as $item) {
                    $item->vrComissao = $commissionPerWaiter;
                    $item->percentCommission = number_format(($percentCommissionPerWaiter), 2, ',', '.');
                }
            }
        }
        else {
            $result = [];
        }

        return $result;
    }
}
