<?php

namespace Database\Factories;

use App\Entities\Manager;
use App\Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class ManagerFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Manager::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            "idAbertura" => Manager::max('idAbertura') + 1,
            "idCaixa" => 1,
            "idOperador" => 99,
            "dtAbertura" => $this->faker->dateTimeBetween()->format('Y-m-d H:i:s'),
            "dtFechamento" => $this->faker->dateTimeBetween()->format('Y-m-d H:i:s'),
            "vrAbertura" => $this->faker->randomFloat(3, 1, 99),
            "flAberto" => 0,
            "vrTrocoEncerramento" => $this->faker->randomFloat(3, 1, 99),
            "flConferencia" => 1,
            "nrClientes" => $this->faker->numberBetween(1, 300),
            "idOrigem" => $this->faker->numberBetween(1, 5),
            "idDestino" => $this->faker->numberBetween(1, 5),
            "stOBS" => $this->faker->text(16),
            "dtAlteracao" => $this->faker->date(),
        ];
    }
}
