<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCxFormasPagamentoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cx_FormasPagamento')) {
            Schema::create('cx_FormasPagamento', function (Blueprint $table) {
                $table->integer('idFormaPagamento', false, true);
                $table->string('stFormaPagamento', 15);
                $table->string('stDescricaoFiscal', 25)->default('DINHEIRO');
                $table->integer('idTipo', false, true);
                $table->boolean('flTroco');
                $table->boolean('flVenda');
                $table->boolean('flSangria');
                $table->boolean('flGiveDifference');
                $table->boolean('flDespesas');
                $table->boolean('flSenha');
                $table->boolean('flAcionaGaveta');
                $table->string('stCor',20)->default('WHITE');
                $table->char('stAtalho');
                $table->boolean('flDelivery');
                $table->integer('idBandeira');
                $table->integer('idTEF')->default(0);
                $table->boolean('flAtivo')->default(true);
                $table->boolean('flFaturado')->default(false);;
                $table->string('stFaturado',50)->default('0');
                $table->boolean('flVendaBrowser')->default(false);;
                $table->dateTime('dtAlteracao')->default(\Carbon\Carbon::now());
                $table->string('ParentId',3)->default('0');
                $table->integer('Order')->default(0);
                $table->decimal('vrTaxa',5, 2)->default(0);
                $table->boolean('flAdquirente')->default(false);
                $table->integer('pagamentoSat')->default(1);
                $table->boolean('flDescontoAutmatico')->default(false);;
                $table->decimal('vrDescontoAutomatico',5, 2)->default(0);

                $table->primary('idFormaPagamento');
//                $table->foreign('idTipo')
//                    ->references('idTipoForma')
//                    ->on('cx_FormasPagamento');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cx_FormasPagamento');
    }
}
