<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCxRepiqueTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cx_Repique')) {
            Schema::create('cx_Repique', function (Blueprint $table) {
                $table->integer('idRepique');
                $table->integer('idAbertura');
                $table->integer('idOperador');
                $table->dateTime('dtData');
                $table->decimal('vrRepique', 9, 2);
                $table->integer('idFormaPagamento');
                $table->integer('idOperadorAutorizador');
                $table->boolean('flTroco');
                $table->boolean('flAtivo');
                $table->dateTime('dtAlteracao');

                $table->primary(['idRepique', 'idAbertura']);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cx_Repique');

    }
}
