<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDlvItensTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('dlv_Itens')) {
            Schema::create('dlv_Itens', function (Blueprint $table) {
                $table->unsignedBigInteger('idAtendimento');
                $table->unsignedBigInteger('nrItem');
                $table->unsignedInteger('idProduto');
                $table->string('stOperador', 20);
                $table->decimal('nrQuantidade', 9, 3);
                $table->dateTime('dtData');
                $table->decimal('vrUnitario', 7, 2);
                $table->decimal('vrTotal', 7, 2);
                $table->string('stOBS', 255)->nullable();
                $table->string('stObservacoes', 30)->nullable();
                $table->string('stValores', 50)->nullable();
                $table->string('stCodigos', 50)->nullable();
                $table->string('stQuantidades', 50)->nullable();
                $table->boolean('flPrint')->default(false);
                $table->dateTime('dtAlteracao')->default(Carbon::now());
                $table->integer('idComanda')->default(0);
                $table->boolean('flAtivo')->default(true);

                $table->primary(['idAtendimento', 'nrItem']);
                $table->foreign('idProduto')->references('idProduto')->on('prd_Produtos');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dlv_Itens');
    }
}
